<?php include 'header.php'; ?>

   <!-- breadcrumb-area-start -->
         <section class="breadcrumb-area tp-breadcrumb-bg breadcrumb-wrap" data-background="assets/img/breadcrumb-bg-1.jpg">
            <div class="container">
               <div class="row">
                  <div class="col-12">
                     <div class="tp-breadcrumb text-center">
                        <div class="tp-breadcrumb-link mb-10">
                           <span class="tp-breadcrumb-link-active"><a href="index.php">Home</a></span>
                           <span> \ About Us</span>
                        </div>
                        <h2 class="tp-breadcrumb-title">Grace Gardens</h2>
                     </div>
                  </div>
               </div>
            </div>
         </section>
         <!-- breadcrumb-area-end -->

<!-- about-area-start -->
<section class="about-area pt-120 pb-90">
   <div class="container">
      <div class="row align-items-center">
         <div class="col-lg-6">
            <div class="tp-about-2-wrap mb-50">
                        <div class="tp-about-2-thumb">
                           <img src="assets/img/about/about-2-thumb-4.jpg" alt="">
                        </div>
                        <div class="tp-about-2-thumb-2">
                           <img src="assets/img/about/about-2-thumb-5.jpg" alt="">
                        </div>
                        <div class="tp-about-2-counter">
                           <h5 class="tp-about-2-counter-count">
                              <span data-purecounter-duration="1" data-purecounter-end="200" class="purecounter"></span>+
                           </h5>
                           <p>Graceful<br> Lives</p>
                        </div>
                     </div>
         </div>
         <div class="col-lg-6">
            <div class="tp-about-content ml-40">
               <div class="tp-section mb-35">
                  <span><img src="assets/img/shape/section-shape-1.svg" alt=""></span>
                  <h5 class="tp-section-subtitle">About Grace Gardens</h5>
                  <h3 class="tp-section-title pb-20">Independent Retirement Living in the Heart of Kerala</h3>
                  <p>
                    At Grace Gardens, the peaceful ambience of Kerala’s countryside blends seamlessly with the comforts of modern living. Our residences are thoughtfully curated to honour independence whilst providing attentive care
                  </p>
               </div>
               <p>
                  Grace Gardens is designed to foster a vibrant community where friendships flourish, cultural heritage is valued, and each day offers new opportunities for growth, joy, and spiritual renewal. Here, the later years of life are not a retreat but a celebration, a season to flourish in safety, purpose, and belonging.
               </p>
            </div>
         </div>
      </div>
      
    <div class="col-md-12" style="font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; color:#333; line-height:1.8; margin-top:40px;">

  <blockquote style="border-left:6px solid #3a7ca5; background:#f8fafc; padding:20px 25px; margin:20px 0; font-size:17px; font-style:italic; color:#444; border-radius:8px; box-shadow:0 2px 8px rgba(0,0,0,0.08);">
    Born from the charitable vision of the IPC Pentecostal Church of Kuwait Charitable Trust and strengthened by the professional expertise of Gracepoint Care Pvt. Ltd., Grace Gardens embodies the harmony of service, tradition, and innovation. What began with the generosity of the IPC PCK Church during its Golden Jubilee has grown into an independent charitable endeavour, dedicated to serving with integrity and love.
  </blockquote>  

  <div style="display:flex; flex-wrap:wrap; gap:20px; margin-top:40px; align-items:center;">
    
    <!-- Video Column -->
    <div style="flex:1 1 300px; max-width:480px; border:2px solid #3a7ca5; border-radius:10px; overflow:hidden; box-shadow:0 4px 12px rgba(0,0,0,0.1);">
      <iframe src="Grace Gardens Retirement Home.mp4" 
              width="100%" height="270" 
              style="border:none; display:block;" 
              controls allowfullscreen>
      </iframe>
    </div>

   <!-- Text Column -->
<div style="flex:2 1 400px; font-size:17px; color:#444; text-align:justify; line-height:1.9; font-weight:500; letter-spacing:0.3px; font-family:'Georgia', serif; background:#fdfdfd; padding:20px 25px; border-left:4px solid #3a7ca5; border-radius:8px; box-shadow:0 2px 10px rgba(0,0,0,0.05);">
  Guided by <span style="color:#3a7ca5; font-weight:600;">Christian principles</span>, our holistic approach ensures that every need is met with <span style="font-style:italic; color:#555;">dignity and care</span>. Residents enjoy not only <span style="font-weight:600;">comfortable living spaces</span> and supportive health and wellbeing programmes but also opportunities for meaningful connection and spiritual nurture. At Grace Gardens, <span style="font-style:italic;">every life story is cherished</span> and every elder is accompanied with <span style="font-weight:600; color:#3a7ca5;">compassion</span> through every season of life.
</div>


  </div>

</div>


   </div>
</section>
<!-- about-area-end -->

<!-- mission-vision-start -->
<section class="processing-area pt-60 pb-60 fix">
   <div class="container">
      <div class="tp-processing-2-border">
         <div class="row">
            <div class="col-lg-12">
               <div class="tp-section mb-35 text-center">
                  <span><img src="assets/img/shape/section-shape-1.svg" alt=""></span>
                  <h5 class="tp-section-subtitle">Our Purpose</h5>
                  <h3 class="tp-section-title pb-30">Mission & Vision</h3>
               </div>
            </div>
         </div>
         <div class="row">
            <!-- Mission -->
            <div class="col-lg-6">
               <div style="background:#f8fafc; padding:30px; border-radius:12px; box-shadow:0 4px 12px rgba(0,0,0,0.06); height:100%;">
                  <h5 style="font-weight:600; font-size:20px; color:#3a7ca5; margin-bottom:15px;">Mission</h5>
                  <p style="font-size:16px; color:#555; line-height:1.8; text-align:justify; margin:0;">
                     Our mission is to provide sanctuaries that uphold dignity and foster belonging, mutual support, and fellowship. Serving with integrity and moral stewardship, we promote holistic wellbeing whilst uniting the richness of tradition with the benefits of modern care and design. We seek to enrich lives by responding to the needs of every stage of life and by cultivating the timeless values of community, faith, and respect through thoughtful design, contemporary comforts, and compassionate care.
                  </p>
               </div>
            </div>
            <!-- Vision -->
            <div class="col-lg-6">
               <div style="background:#ffffff; padding:30px; border-radius:12px; box-shadow:0 4px 12px rgba(0,0,0,0.06); height:100%;">
                  <h5 style="font-weight:600; font-size:20px; color:#3a7ca5; margin-bottom:15px;">Vision</h5>
                  <p style="font-size:16px; color:#555; line-height:1.8; text-align:justify; margin:0;">
                     We envision a future where the golden years are lived in safety and comfort, free from loneliness and uncertainty. At Grace Gardens, the challenges of ageing are met with compassion, companionship, and care, creating a community where retirement becomes a season of meaning, connection, and spiritual fulfilment.
                  </p>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<!-- mission-vision-end -->



<!-- location-ambiance-start -->
<section class="processing-area pt-60 pb-60 fix">
   <div class="container">
      <div class="tp-processing-2-border">
         <div class="row">
            <div class="col-lg-12">
               <div class="tp-section mb-35 text-center">
                  <span><img src="assets/img/shape/section-shape-1.svg" alt=""></span>
                  <h5 class="tp-section-subtitle">Where We Are</h5>
                  <h3 class="tp-section-title pb-30">Location & Ambiance</h3>
               </div>
            </div>
         </div>
         <div class="row">
            <div class="col-lg-6">
               <div style="padding:20px;">
                  <h5 style="font-weight:600; margin-bottom:10px;">Location</h5>
                  <p>Venmoney, Chengannur, Alappuzha District, Kerala, India. Just 1 KM from Kollam–Theni highway.</p>
               </div>
            </div>
            <div class="col-lg-6">
               <div style="padding:20px;">
                  <h5 style="font-weight:600; margin-bottom:10px;">Ambiance</h5>
                  <p>
                     Nestled amidst Kerala's lush greenery, Grace Gardens retirement home offers a serene and picturesque setting, allowing residents to relish the tranquillity of nature while enjoying modern amenities.
                  </p>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<!-- location-ambiance-end -->


<!-- lifestyle-section-start -->
<section class="services-area pt-60 pb-90">
   <div class="container">
      <div class="row">
         <div class="col-lg-12 text-center">
            <div class="tp-section mb-35">
               <span><img src="assets/img/shape/section-shape-1.svg" alt=""></span>
               <h5 class="tp-section-subtitle">Living Experience</h5>
               <h3 class="tp-section-title pb-30">Life at Grace Gardens</h3>
            </div>
         </div>
      </div>

      <div class="row">
         <!-- Independent Living -->
         <div class="col-lg-6">
            <div class="tp-service-item mb-30">
               <h4>Independent Living: <span style="font-weight:400;">Enjoy your freedom and privacy</span></h4>
               <p>
                  Unlike traditional nursing homes, Grace Gardens promotes independent living. Residents have their own private living spaces, maintaining autonomy while receiving assistance when required.
               </p>
            </div>
         </div>
         <!-- Community -->
         <div class="col-lg-6">
            <div class="tp-service-item mb-30">
               <h4>Community & Social Engagement: <span style="font-weight:400;">More than retirement living</span></h4>
               <p>
                  Residents forge new friendships, engage in shared interests, and participate in cultural and spiritual events, enriching social lives while combating isolation.
               </p>
            </div>
         </div>
         <!-- Recreational Activities -->
         <div class="col-lg-6">
            <div class="tp-service-item mb-30">
               <h4>Recreational Activities</h4>
               <p>
                  A wide variety of activities including farming, gardening, self-help classes, cooking workshops, and excursions to explore Kerala’s natural and cultural landmarks.
               </p>
            </div>
         </div>
         <!-- Healthcare -->
         <div class="col-lg-6">
            <div class="tp-service-item mb-30">
               <h4>Healthcare & Support Services</h4>
               <p>
                  Regular medical check-ups, 24/7 trained professionals, and access to world-class hospitals within 20–30 minutes. Emergency medical transportation and medication assistance ensure complete wellbeing.
               </p>
            </div>
         </div>
      </div>
   </div>
</section>
<!-- lifestyle-section-end -->


<!-- security-care-start -->
<section class="processing-area pt-60 pb-60 fix" style="background:#fafafa;">
   <div class="container">
      <div class="tp-processing-2-border">
         <div class="row">
            <div class="col-lg-6">
               <div class="tp-section mb-35">
                  <span><img src="assets/img/shape/section-shape-1.svg" alt=""></span>
                  <h5 class="tp-section-subtitle">Peace of Mind</h5>
                  <h3 class="tp-section-title pb-20">Safety, Security & Care</h3>
                  <p>
                     With 24/7 surveillance, trained staff, and emergency response systems, Grace Gardens ensures residents live with absolute peace of mind. 
                  </p>
                  <p>
                     Personalized care plans and dietary meal options ensure every resident’s preferences and wellbeing are respected.
                  </p>
                  <p>
                     Additional services include housekeeping, laundry, on-call transportation, and assistance for medical appointments.
                  </p>
               </div>
            </div>
            <div class="col-lg-6">
               <img src="assets/img/CCTV-In-Nursing-Home-2.jpg" alt="Safety and Care at Grace Gardens" style="border-radius:12px;">
            </div>
         </div>
      </div>
   </div>
</section>
<!-- security-care-end -->


<!-- quality-of-life-start -->
<section class="about-area pt-120 pb-90">
   <div class="container">
      <div class="row align-items-center">
         <div class="col-lg-12">
            <div class="tp-about-content text-center">
               <div class="tp-section mb-35">
                  <span><img src="assets/img/shape/section-shape-1.svg" alt=""></span>
                  <h5 class="tp-section-subtitle">Our Promise</h5>
                  <h3 class="tp-section-title pb-20">Quality of Life – No Compromise</h3>
                  <p>
                     At Grace Gardens, we aim to enhance quality of life by harmoniously blending comfort, care, and independence. Seniors can embrace retirement with joy, fulfillment, and a renewed sense of purpose in a supportive and enriching environment.
                  </p>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<!-- quality-of-life-end -->

<?php include 'footer.php'; ?>
